<?php

namespace VM\FinancialStatementsBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use VM\AdminBundle\Controller\AbstractController;
use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieInwestycjiDS;
use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieProdukcjiDS;
use VM\FinancialStatementsBundle\Services\Gra;
use VM\FinancialStatementsBundle\Services\Lokata;
use VM\FinancialStatementsBundle\Services\Reports\FullReport;
use VM\FinancialStatementsBundle\Services\Reports\SimpleReport;

class RoundsController extends AbstractController
{
    public function indexAction()
    {

    }

    public function nextRoundAction($groupId)
    {
        $apiGetter = $this->getApiGetter();
        $company = $apiGetter->getGroupCompanyOrFalse($apiGetter->getGroup($groupId));
        if(!$company)
        {
            throw new \Exception('This group has no company!');
        }

        $companyEmployees = $company->getEmployees();

        $nakladyNaPiR = 0.0;
        $nakladyNaInnowacje = 0.0;
        $wynagrodzenia = 0.0;

        foreach($companyEmployees as $employee)
        {
            $department = $employee->getDepartment();
            switch($department->getSymbol())
            {
                case 'DISCOVER':
                    $nakladyNaInnowacje += $employee->getEmployee()->getSalary()*12;
                    break;
                case 'PROMOTION':
                    $nakladyNaPiR += $employee->getEmployee()->getSalary()*12;
                    break;
                default:
                    break;
            }

            $wynagrodzenia += $employee->getEmployee()->getSalary()*12;
        }
    }
}